<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Feedback.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /auth/wechat_login.php');
    exit;
}

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$feedback = new Feedback();
$feedbacks = $feedback->getUserFeedbacks($_SESSION['user']['id'], $page);
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>我的反馈 - 朋友圈访客查询系统</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css" rel="stylesheet">
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <!-- 加载动画 -->
    <div class="loading-overlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">加载中...</div>
    </div>

    <div class="feedback-page">
        <div class="container">
            <div class="feedback-header">
                <h1>我的反馈</h1>
                <p>您可以在这里查看您提交的所有反馈</p>
            </div>

            <div class="row justify-content-center">
                <div class="col-md-8">
                    <?php if (isset($_GET['success'])): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>反馈提交成功！我们会尽快处理。
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>
                    
                    <div class="feedback-list">
                        <div class="list-header">
                            <h2>反馈列表</h2>
                            <a href="/feedback/create.php" class="btn-submit">
                                <i class="fas fa-plus me-2"></i>提交新反馈
                            </a>
                        </div>

                        <?php if (empty($feedbacks)): ?>
                        <div class="empty-state">
                            <i class="fas fa-comments"></i>
                            <p>您还没有提交过反馈</p>
                            <a href="/feedback/create.php" class="btn-submit">
                                <i class="fas fa-plus me-2"></i>提交反馈
                            </a>
                        </div>
                        <?php else: ?>
                        <div class="feedback-items">
                            <?php foreach ($feedbacks as $item): ?>
                            <div class="feedback-item">
                                <div class="feedback-header">
                                    <h3><?php echo htmlspecialchars($item['title']); ?></h3>
                                    <span class="feedback-time">
                                        <?php echo date('Y-m-d H:i', strtotime($item['created_at'])); ?>
                                    </span>
                                </div>
                                <div class="feedback-content">
                                    <?php echo htmlspecialchars(mb_substr($item['content'], 0, 100)) . '...'; ?>
                                </div>
                                <div class="feedback-footer">
                                    <span class="feedback-status <?php echo $item['status']; ?>">
                                        <?php echo getStatusText($item['status']); ?>
                                    </span>
                                    <a href="/feedback/detail.php?id=<?php echo $item['id']; ?>" 
                                       class="feedback-link">
                                        查看详情
                                        <i class="fas fa-chevron-right ms-1"></i>
                                    </a>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // 隐藏初始加载动画
        Loading.hide();
    });
    </script>

    <?php include '../includes/footer.php'; ?>
</body>
</html>

<?php
function getStatusColor($status) {
    switch ($status) {
        case 'pending':
            return 'secondary';
        case 'processing':
            return 'primary';
        case 'resolved':
            return 'success';
        case 'closed':
            return 'dark';
        default:
            return 'secondary';
    }
}

function getStatusText($status) {
    switch ($status) {
        case 'pending':
            return '待处理';
        case 'processing':
            return '处理中';
        case 'resolved':
            return '已解决';
        case 'closed':
            return '已关闭';
        default:
            return '未知状态';
    }
} 