<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Feedback.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /auth/wechat_login.php');
    exit;
}

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $type = $_POST['type'];
    $title = $_POST['title'];
    $content = $_POST['content'];
    $images = [];
    
    // 处理图片上传
    if (isset($_FILES['images'])) {
        foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
            if ($_FILES['images']['error'][$key] === UPLOAD_ERR_OK) {
                $ext = pathinfo($_FILES['images']['name'][$key], PATHINFO_EXTENSION);
                $filename = uniqid() . '.' . $ext;
                $uploadPath = UPLOAD_PATH . $filename;
                
                if (move_uploaded_file($tmp_name, $uploadPath)) {
                    $images[] = '/uploads/' . $filename;
                }
            }
        }
    }
    
    // 创建反馈
    $feedback = new Feedback();
    $feedbackId = $feedback->create(
        $_SESSION['user']['id'],
        $type,
        $title,
        $content,
        !empty($images) ? implode('|', $images) : null
    );
    
    if ($feedbackId) {
        header('Location: /feedback/list.php?success=1');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>提交反馈 - 朋友圈访客查询系统</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css" rel="stylesheet">
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <!-- 加载动画 -->
    <div class="loading-overlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">加载中...</div>
    </div>

    <div class="feedback-page">
        <div class="container">
            <div class="feedback-header">
                <h1>提交反馈</h1>
                <p>您的反馈对我们很重要，我们会认真处理每一条反馈</p>
            </div>

            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="feedback-form">
                        <form method="POST" enctype="multipart/form-data" id="feedbackForm">
                            <div class="mb-4">
                                <label class="form-label">反馈类型</label>
                                <select name="type" class="form-select" required>
                                    <option value="bug">问题反馈</option>
                                    <option value="suggestion">功能建议</option>
                                    <option value="other">其他</option>
                                </select>
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label">标题</label>
                                <input type="text" 
                                       name="title" 
                                       class="form-control" 
                                       required
                                       placeholder="请简要描述您的反馈">
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label">详细内容</label>
                                <textarea name="content" 
                                          class="form-control" 
                                          rows="5" 
                                          required
                                          placeholder="请详细描述您遇到的问题或建议..."></textarea>
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label">
                                    上传截图
                                    <small class="text-muted">（可选，最多3张）</small>
                                </label>
                                <input type="file" 
                                       name="images[]" 
                                       class="form-control" 
                                       multiple
                                       accept="image/*" 
                                       onchange="handleImageSelect(this)">
                                <div class="image-preview" id="imagePreview"></div>
                            </div>
                            
                            <button type="submit" class="btn-submit">
                                <i class="fas fa-paper-plane me-2"></i>提交反馈
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // 隐藏初始加载动画
        Loading.hide();

        // 表单提交时显示加载动画
        document.getElementById('feedbackForm').addEventListener('submit', function() {
            Loading.show();
        });
    });

    function handleImageSelect(input) {
        if (input.files.length > 3) {
            alert('最多只能上传3张图片');
            input.value = '';
            return;
        }

        const preview = document.getElementById('imagePreview');
        preview.innerHTML = '';

        Array.from(input.files).forEach((file, index) => {
            const reader = new FileReader();
            reader.onload = function(e) {
                const div = document.createElement('div');
                div.className = 'preview-item';
                div.innerHTML = `
                    <img src="${e.target.result}" alt="预览图片">
                    <div class="remove-btn" onclick="removeImage(${index}, this)">
                        <i class="fas fa-times"></i>
                    </div>
                `;
                preview.appendChild(div);
            }
            reader.readAsDataURL(file);
        });
    }

    function removeImage(index, btn) {
        const input = document.querySelector('input[type="file"]');
        const dt = new DataTransfer();
        const { files } = input;

        for (let i = 0; i < files.length; i++) {
            if (i !== index) {
                dt.items.add(files[i]);
            }
        }

        input.files = dt.files;
        btn.closest('.preview-item').remove();
    }
    </script>

    <?php include '../includes/footer.php'; ?>
</body>
</html> 