<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/User.php';
require_once '../includes/Config.php';

// 获取配置
$config = Config::getInstance();

// 如果已经登录，直接跳转到首页
if (isset($_SESSION['user'])) {
    // 如果有重定向URL，跳转到之前的页面
    if (isset($_SESSION['redirect_url'])) {
        $redirectUrl = $_SESSION['redirect_url'];
        unset($_SESSION['redirect_url']); // 清除session中的URL
        header('Location: ' . $redirectUrl);
        exit;
    }
    // 否则跳转到首页
    header('Location: /posts/index.php');
    exit;
}

// 处理微信回调
if (isset($_GET['code'])) {
    $user = new User();
    if ($user->handleWechatCallback($_GET['code'])) {
        // 登录成功后，检查是否需要重定向到之前的页面
        if (isset($_SESSION['redirect_url'])) {
            $redirectUrl = $_SESSION['redirect_url'];
            unset($_SESSION['redirect_url']); // 清除session中的URL
            header('Location: ' . $redirectUrl);
            exit;
        }
        // 否则跳转到首页
        header('Location: /posts/index.php');
        exit;
    } else {
        die('微信登录失败');
    }
}

// 生成微信授权URL
$state = bin2hex(random_bytes(8));
$_SESSION['oauth_state'] = $state;

// 修复：确保 site_url 和路径之间只有一个斜杠
$siteUrl = rtrim($config->get('site_url'), '/'); // 移除末尾斜杠
$redirectUri = urlencode($siteUrl . '/auth/wechat_login.php');

// 获取配置的OAuth API地址，如果为空则使用官方API
$oauthApi = $config->get('wechat_oauth_api');
if (empty($oauthApi)) {
    // 使用官方微信OAuth API
    $authUrl = sprintf(
        "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=%s#wechat_redirect",
        $config->get('wechat_appid'),
        $redirectUri,
        $state
    );
} else {
    // 使用配置的第三方回调API（如：http://wx.55519.cn/api 或 https://weixin.ymysz.cn/api.php）
    $authUrl = sprintf(
        "%s?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=%s#wechat_redirect",
        rtrim($oauthApi, '/?'), // 移除末尾的斜杠或问号
        $config->get('wechat_appid'),
        $redirectUri,
        $state
    );
}

// 重定向到微信授权页面
header('Location: ' . $authUrl);
exit; 