<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/WechatAuth.php';

try {
    // 验证必要参数
    if (!isset($_GET['code']) || !isset($_GET['state'])) {
        throw new Exception('缺少必要的参数');
    }

    $wechat = new WechatAuth();
    $user = $wechat->handleCallback($_GET['code'], $_GET['state']);

    // 设置用户会话
    $_SESSION['user'] = array(
        'id' => $user['id'],
        'openid' => $user['openid'],
        'nickname' => $user['nickname'],
        'avatar' => $user['avatar'],
        'role' => $user['role']
    );

    // 清除state
    unset($_SESSION['wechat_state']);

    // 跳转到首页
    header('Location: /posts/index.php');
    exit;
} catch (Exception $e) {
    die('微信登录失败：' . $e->getMessage());
} 