/**
 * 朋友圈访客查询系统 - 前端脚本
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

// 加载动画控制
const Loading = {
    show() {
        const overlay = document.querySelector('.loading-overlay');
        if (!overlay) {
            const div = document.createElement('div');
            div.className = 'loading-overlay';
            div.innerHTML = '<div class="loading-spinner"></div>';
            document.body.appendChild(div);
            // 强制重绘
            div.offsetHeight;
            div.classList.add('show');
        } else {
            overlay.classList.add('show');
        }
    },
    
    hide() {
        const overlay = document.querySelector('.loading-overlay');
        if (overlay) {
            overlay.classList.remove('show');
        }
    }
};

// 提示框控制
const Toast = {
    container: null,
    
    init() {
        if (!this.container) {
            this.container = document.createElement('div');
            this.container.className = 'toast-container';
            document.body.appendChild(this.container);
        }
    },
    
    show(message, type = 'info') {
        this.init();
        
        const toast = document.createElement('div');
        toast.className = `toast ${type}`;
        toast.innerHTML = `
            <i class="fas fa-${type === 'success' ? 'check-circle' : 
                           type === 'error' ? 'times-circle' : 
                           'info-circle'} me-2"></i>
            <span>${message}</span>
        `;
        
        this.container.appendChild(toast);
        
        // 3秒后自动消失
        setTimeout(() => {
            toast.style.opacity = '0';
            setTimeout(() => {
                this.container.removeChild(toast);
            }, 300);
        }, 3000);
    },
    
    success(message) {
        this.show(message, 'success');
    },
    
    error(message) {
        this.show(message, 'error');
    },
    
    info(message) {
        this.show(message, 'info');
    }
};

// 数据加载占位
const Skeleton = {
    create(type) {
        const div = document.createElement('div');
        div.className = 'skeleton';
        
        switch (type) {
            case 'text':
                div.style.height = '1em';
                div.style.marginBottom = '0.5em';
                break;
            case 'circle':
                div.style.width = '50px';
                div.style.height = '50px';
                div.style.borderRadius = '50%';
                break;
            case 'rectangle':
                div.style.height = '100px';
                break;
        }
        
        return div;
    },
    
    replace(element, type) {
        const skeleton = this.create(type);
        element.style.display = 'none';
        element.parentNode.insertBefore(skeleton, element);
        return skeleton;
    },
    
    remove(skeleton, element) {
        skeleton.parentNode.removeChild(skeleton);
        element.style.display = '';
    }
};

// 实时数据刷新
const LiveData = {
    intervals: {},
    
    start(key, callback, interval = 30000) {
        this.stop(key);
        this.intervals[key] = setInterval(callback, interval);
    },
    
    stop(key) {
        if (this.intervals[key]) {
            clearInterval(this.intervals[key]);
            delete this.intervals[key];
        }
    },
    
    stopAll() {
        Object.keys(this.intervals).forEach(key => this.stop(key));
    }
};

// 移动端适配
const Mobile = {
    isMobile() {
        return window.innerWidth <= 768;
    },
    
    init() {
        if (this.isMobile()) {
            document.body.classList.add('mobile');
        }
        
        window.addEventListener('resize', () => {
            if (this.isMobile()) {
                document.body.classList.add('mobile');
            } else {
                document.body.classList.remove('mobile');
            }
        });
    }
};

// 初始化
document.addEventListener('DOMContentLoaded', function() {
    Mobile.init();
}); 