<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Admin.php';

// 检查管理员是否登录
if (!isset($_SESSION['admin'])) {
    header('Location: /admin/login.php');
    exit;
}

$db = Database::getInstance();

// 处理配置更新
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $configs = [
        'enable_vip_pay' => $_POST['enable_vip_pay'] ?? '0',
        'enable_vip_card' => $_POST['enable_vip_card'] ?? '0',
        'card_purchase_url' => $_POST['card_purchase_url'] ?? '',
        'card_purchase_description' => $_POST['card_purchase_description'] ?? '',
        'card_purchase_contact' => $_POST['card_purchase_contact'] ?? ''
    ];
    
    foreach ($configs as $key => $value) {
        $db->query("UPDATE system_config SET value = ? WHERE `key` = ?", [$value, $key]);
    }
    
    $_SESSION['success'] = '配置更新成功！';
    header('Location: /admin/vip_config.php');
    exit;
}

// 获取当前配置
$configs = $db->query("SELECT `key`, value FROM system_config WHERE `key` IN ('enable_vip_pay', 'enable_vip_card', 'card_purchase_url', 'card_purchase_description', 'card_purchase_contact')")->fetchAll(PDO::FETCH_KEY_PAIR);

// 加载管理后台模板
require_once 'layout/header.php';
?>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">VIP功能配置</h1>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php 
                echo $_SESSION['success'];
                unset($_SESSION['success']);
                ?>
                <button type="button" class="close" data-bs-dismiss="alert">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">VIP功能开关设置</h3>
                </div>
                <form action="" method="post">
                    <div class="card-body">
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="enableVipPay" 
                                       name="enable_vip_pay" value="1" 
                                       <?php echo ($configs['enable_vip_pay'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="enableVipPay">启用在线支付购买VIP</label>
                            </div>
                            <small class="form-text text-muted">开启后，用户可以通过在线支付购买VIP会员</small>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="enableVipCard" 
                                       name="enable_vip_card" value="1" 
                                       <?php echo ($configs['enable_vip_card'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="enableVipCard">启用卡密购买VIP</label>
                            </div>
                            <small class="form-text text-muted">开启后，用户可以通过卡密激活VIP会员</small>
                        </div>

                        <hr>
                        <h5>卡密购买设置</h5>
                        
                        <div class="form-group">
                            <label for="cardPurchaseUrl">购买链接</label>
                            <input type="text" class="form-control" id="cardPurchaseUrl" 
                                   name="card_purchase_url" 
                                   value="<?php echo htmlspecialchars($configs['card_purchase_url'] ?? ''); ?>"
                                   placeholder="请输入卡密购买链接">
                            <small class="form-text text-muted">用户点击"购买卡密"按钮后跳转的链接</small>
                        </div>

                        <div class="form-group">
                            <label for="cardPurchaseDescription">购买说明</label>
                            <textarea class="form-control" id="cardPurchaseDescription" 
                                      name="card_purchase_description" rows="3" 
                                      placeholder="请输入卡密购买说明"><?php echo htmlspecialchars($configs['card_purchase_description'] ?? ''); ?></textarea>
                            <small class="form-text text-muted">显示在卡密购买按钮下方的说明文字，支持换行</small>
                        </div>

                        <div class="form-group">
                            <label for="cardPurchaseContact">联系方式</label>
                            <input type="text" class="form-control" id="cardPurchaseContact" 
                                   name="card_purchase_contact" 
                                   value="<?php echo htmlspecialchars($configs['card_purchase_contact'] ?? ''); ?>"
                                   placeholder="请输入联系方式">
                            <small class="form-text text-muted">显示在购买说明下方的联系方式</small>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">保存设置</button>
                    </div>
                </form>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">功能说明</h3>
                </div>
                <div class="card-body">
                    <h5>在线支付购买</h5>
                    <p>用户可以直接通过易支付进行在线支付购买VIP会员。</p>
                    <ul>
                        <li>支持多种支付方式</li>
                        <li>自动开通会员</li>
                        <li>实时到账</li>
                    </ul>

                    <h5 class="mt-4">卡密购买</h5>
                    <p>用户可以通过卡密码激活VIP会员。</p>
                    <ul>
                        <li>支持批量生成卡密</li>
                        <li>可以设置卡密有效期</li>
                        <li>适合线下销售</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
</div>

<?php require_once 'layout/footer.php'; ?> 