<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../includes/Database.php';
require_once __DIR__ . '/../../includes/Admin.php';

// 验证管理员权限
$admin = new Admin();
$admin->checkAccess();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>朋友圈访客查询系统</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="/assets/css/style.css" rel="stylesheet">
    <link href="/assets/css/admin.css" rel="stylesheet">
    <!-- 帮助提示 -->
    <link href="https://cdn.jsdelivr.net/npm/driver.js@1.3.1/dist/driver.css" rel="stylesheet">
    <style>
        /* VIP管理菜单样式 */
        .menu-link[data-bs-toggle="collapse"] {
            position: relative;
        }
        .menu-link[data-bs-toggle="collapse"] .fa-chevron-down {
            transition: transform 0.2s;
            font-size: 0.8em;
        }
        .menu-link[data-bs-toggle="collapse"][aria-expanded="true"] .fa-chevron-down {
            transform: rotate(180deg);
        }
        #vipSubmenu {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 4px;
            margin: 0 0.5rem;
            padding: 0.5rem 0;
        }
        #vipSubmenu .menu-link {
            padding: 0.5rem 1rem;
            font-size: 0.9em;
            opacity: 0.8;
            transition: all 0.2s;
            border-radius: 4px;
            margin: 0.2rem 0.5rem;
        }
        #vipSubmenu .menu-link:hover {
            opacity: 1;
            background: rgba(255, 255, 255, 0.1);
        }
        #vipSubmenu .menu-link i {
            width: 20px;
            text-align: center;
            margin-right: 8px;
            font-size: 0.9em;
        }
        #vipSubmenu .nav-item.active .menu-link {
            background: var(--bs-primary);
            color: white;
            opacity: 1;
        }
        /* 高亮当前页面菜单 */
        #vipSubmenu .menu-link[href="<?php echo $_SERVER['PHP_SELF']; ?>"] {
            background: var(--bs-primary);
            color: white;
            opacity: 1;
        }
    </style>
</head>
<body class="admin-body">
    <!-- 加载动画 -->
    <div class="loading-overlay">
        <div class="loading-spinner"></div>
    </div>

    <!-- 侧边栏 -->
    <div class="admin-sidebar">
        <div class="sidebar-header">
            <i class="fas fa-eye me-2"></i>
            <span>访客查询系统</span>
        </div>
        <div class="sidebar-user">
            <?php if (isset($_SESSION['user'])): ?>
                <!-- 微信登录用户显示 -->
                <img src="<?php echo htmlspecialchars($_SESSION['user']['avatar']); ?>" 
                     class="rounded-circle" 
                     width="50" height="50" 
                     alt="<?php echo htmlspecialchars($_SESSION['user']['nickname']); ?>">
                <div class="user-info">
                    <div class="user-name"><?php echo htmlspecialchars($_SESSION['user']['nickname']); ?></div>
                    <div class="user-role">管理员</div>
                </div>
            <?php else: ?>
                <!-- 账号密码登录用户显示 -->
                <img src="/assets/images/admin-avatar.png" 
                     class="rounded-circle" 
                     width="50" height="50" 
                     alt="<?php echo htmlspecialchars($_SESSION['admin']['name']); ?>">
                <div class="user-info">
                    <div class="user-name"><?php echo htmlspecialchars($_SESSION['admin']['name']); ?></div>
                    <div class="user-role">系统管理员</div>
                </div>
            <?php endif; ?>
        </div>
        <ul class="sidebar-menu">
            <li class="menu-item" data-step="1" data-intro="这里是系统的控制面板，展示整体数据概况">
                <a href="/admin/index.php" class="menu-link">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>控制面板</span>
                </a>
            </li>
            <li class="menu-item" data-step="2" data-intro="在这里管理所有用户">
                <a href="/admin/users.php" class="menu-link">
                    <i class="fas fa-users"></i>
                    <span>用户管理</span>
                </a>
            </li>
            <li class="menu-item" data-step="3" data-intro="在这里管理所有动态内容">
                <a href="/admin/posts.php" class="menu-link">
                    <i class="fas fa-file-alt"></i>
                    <span>动态管理</span>
                </a>
            </li>
            <li class="menu-item" data-step="4" data-intro="查看详细的访问统计数据">
                <a href="/admin/stats.php" class="menu-link">
                    <i class="fas fa-chart-bar"></i>
                    <span>访问统计</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="/admin/growth.php" class="menu-link">
                    <i class="fas fa-chart-line"></i>
                    <span>增长分析</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="/admin/feedback.php" class="menu-link">
                    <i class="fas fa-comments"></i>
                    <span>反馈管理</span>
                </a>
            </li>
            <!-- VIP管理菜单 -->
            <li class="menu-item">
                <a href="#" class="menu-link" data-bs-toggle="collapse" data-bs-target="#vipSubmenu">
                    <i class="fas fa-crown"></i>
                    <span>VIP管理</span>
                    <i class="fas fa-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="vipSubmenu">
                    <ul class="nav ms-4 mt-2">
                        <li class="nav-item">
                            <a href="/admin/vip_plans.php" class="menu-link">
                                <i class="fas fa-tags"></i>
                                <span>套餐管理</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="/admin/user_vip.php" class="menu-link">
                                <i class="fas fa-user-tag"></i>
                                <span>会员管理</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="/admin/vip_config.php" class="menu-link">
                                <i class="fas fa-toggle-on"></i>
                                <span>功能开关</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="/admin/vip_cards.php" class="menu-link">
                                <i class="fas fa-ticket-alt"></i>
                                <span>卡密管理</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="/admin/orders.php" class="menu-link">
                                <i class="fas fa-shopping-cart"></i>
                                <span>订单管理</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="/admin/epay_config.php" class="menu-link">
                                <i class="fas fa-credit-card"></i>
                                <span>支付配置</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            <li class="menu-item">
                <a href="/admin/config.php" class="menu-link">
                    <i class="fas fa-cog"></i>
                    <span>系统配置</span>
                </a>
            </li>
             <li class="menu-item <?php echo $currentPage === 'faq.php' ? 'active' : ''; ?>">
            <a href="/admin/faq.php" class="menu-link">
                <i class="fas fa-question-circle"></i>
                <span>常见问题</span>
            </a>
            <li class="menu-item">
                <a href="/" class="menu-link">
                    <i class="fas fa-home"></i>
                    <span>返回前台</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="/admin/change_password.php" class="menu-link">
                    <i class="fas fa-key"></i>
                    <span>修改密码</span>
                </a>
            </li>
            <li class="menu-item">
                <?php if (isset($_SESSION['user'])): ?>
                <a href="/auth/logout.php" class="menu-link">
                <?php else: ?>
                <a href="/admin/logout.php" class="menu-link">
                <?php endif; ?>
                    <i class="fas fa-sign-out-alt"></i>
                    <span>退出登录</span>
                </a>
            </li>
        </ul>
    </div>

    <!-- 主要内容区 -->
    <div class="admin-main">
        <div class="admin-header">
            <button type="button" class="btn btn-link sidebar-toggle">
                <i class="fas fa-bars"></i>
            </button>
            <div class="breadcrumb mb-0">
                <?php if (isset($pageTitle)): ?>
                    <i class="<?php echo $pageIcon ?? 'fas fa-tachometer-alt'; ?> me-2"></i>
                    <?php echo htmlspecialchars($pageTitle); ?>
                <?php endif; ?>
            </div>
            <div class="header-actions">
                <button type="button" class="btn btn-outline-primary btn-sm" id="startTour">
                    <i class="fas fa-question-circle me-1"></i>
                    使用帮助
                </button>
            </div>
        </div>
        <div class="admin-content p-4"> 