<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/Database.php';
require_once __DIR__ . '/../includes/Admin.php';
require_once __DIR__ . '/../includes/EpayService.php';

// 验证管理员权限
$admin = new Admin();
$admin->checkAccess();

$db = Database::getInstance();

// 处理保存配置
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $configs = [
        'epay_url' => $_POST['epay_url'] ?? '',
        'epay_pid' => $_POST['epay_pid'] ?? '',
        'epay_key' => $_POST['epay_key'] ?? '',
        'card_purchase_url' => $_POST['card_purchase_url'] ?? '',
        'card_purchase_description' => $_POST['card_purchase_description'] ?? '',
        'card_purchase_contact' => $_POST['card_purchase_contact'] ?? '',
        'card_purchase_status' => $_POST['card_purchase_status'] ?? 'disabled'
    ];
    
    foreach ($configs as $key => $value) {
        $db->query("UPDATE system_config SET value = ? WHERE `key` = ?", [$value, $key]);
    }
    
    // 测试配置
    $epay = new EpayService();
    $testResult = $epay->testConfig();
    
    if ($testResult['code'] === 0) {
        $message = ['type' => 'success', 'text' => '配置保存成功，接口连接正常'];
    } else {
        $message = ['type' => 'warning', 'text' => '配置已保存，但' . $testResult['msg']];
    }
}

// 获取当前配置
$configs = $db->query("SELECT `key`, value FROM system_config WHERE `key` LIKE 'epay_%' OR `key` LIKE 'card_purchase_%'")->fetchAll(PDO::FETCH_KEY_PAIR);

// 设置页面标题
$pageTitle = '易支付配置';
$pageIcon = 'fas fa-credit-card';

// 加载页头
require_once __DIR__ . '/layout/header.php';
?>

<div class="container-fluid">
    <?php if (isset($message)): ?>
    <div class="alert alert-<?php echo $message['type']; ?> alert-dismissible fade show">
        <?php echo $message['text']; ?>
        <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>

    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">易支付配置</h5>
        </div>
        <div class="card-body">
            <form method="post" action="">
                <div class="form-group mb-3">
                    <label for="epay_url">接口地址</label>
                    <input type="url" class="form-control" id="epay_url" name="epay_url" 
                        value="<?php echo htmlspecialchars($configs['epay_url'] ?? ''); ?>" 
                        placeholder="例如：https://pay.example.com" required>
                    <small class="form-text text-muted">请输入完整的易支付接口地址，结尾不要带斜杠</small>
                </div>

                <div class="form-group mb-3">
                    <label for="epay_pid">商户ID</label>
                    <input type="text" class="form-control" id="epay_pid" name="epay_pid" 
                        value="<?php echo htmlspecialchars($configs['epay_pid'] ?? ''); ?>" 
                        required>
                </div>

                <div class="form-group mb-3">
                    <label for="epay_key">商户密钥</label>
                    <input type="text" class="form-control" id="epay_key" name="epay_key" 
                        value="<?php echo htmlspecialchars($configs['epay_key'] ?? ''); ?>" 
                        required>
                </div>

                <div class="alert alert-info">
                    <h6><i class="fas fa-info-circle me-2"></i>通知地址配置说明</h6>
                    <p class="mb-0">
                        异步通知地址：<?php echo rtrim($configs['site_url'] ?? '', '/') . '/vip/notify.php'; ?><br>
                        同步跳转地址：<?php echo rtrim($configs['site_url'] ?? '', '/') . '/vip/return.php'; ?>
                    </p>
                </div>

                <hr class="my-4">

                <h5 class="mb-3">卡密购买设置</h5>
                
                <div class="form-group mb-3">
                    <label for="card_purchase_status">启用卡密购买</label>
                    <div class="custom-control custom-switch">
                        <input type="checkbox" class="custom-control-input" id="card_purchase_status" 
                            name="card_purchase_status" value="enabled" 
                            <?php echo ($configs['card_purchase_status'] ?? '') === 'enabled' ? 'checked' : ''; ?>>
                        <label class="custom-control-label" for="card_purchase_status">开启后前台显示卡密购买入口</label>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="card_purchase_url">购买链接</label>
                    <input type="url" class="form-control" id="card_purchase_url" name="card_purchase_url" 
                        value="<?php echo htmlspecialchars($configs['card_purchase_url'] ?? ''); ?>" 
                        placeholder="请输入卡密购买链接">
                    <small class="form-text text-muted">可以是淘宝、微店等购买地址</small>
                </div>

                <div class="form-group mb-3">
                    <label for="card_purchase_description">购买说明</label>
                    <textarea class="form-control" id="card_purchase_description" name="card_purchase_description" 
                        rows="3" placeholder="请输入卡密购买相关说明"><?php echo htmlspecialchars($configs['card_purchase_description'] ?? ''); ?></textarea>
                </div>

                <div class="form-group mb-3">
                    <label for="card_purchase_contact">联系方式</label>
                    <input type="text" class="form-control" id="card_purchase_contact" name="card_purchase_contact" 
                        value="<?php echo htmlspecialchars($configs['card_purchase_contact'] ?? ''); ?>" 
                        placeholder="请输入购买咨询联系方式">
                    <small class="form-text text-muted">可以填写QQ、微信等联系方式</small>
                </div>

                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>保存配置
                </button>
            </form>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/layout/footer.php'; ?> 