# 朋友圈访客查询系统

一个基于PHP的朋友圈访客记录与追踪系统，支持微信登录、动态发布、访客追踪、VIP会员等功能。

## 👨‍💻 作者信息

- **作者**：锅岛主
- **网站**：[https://ggdao.net](https://ggdao.net)
- **微信**：IJG55555
- **版权**：Copyright (c) 2026 锅岛主

## ✨ 核心功能

### 用户端
- 微信OAuth登录
- 发布动态（支持多图）
- 分享到朋友圈
- 查看访客记录
- VIP会员功能
- 用户反馈系统

### 管理端
- 数据统计看板
- 用户管理
- 动态管理
- VIP套餐管理
- 卡密管理
- 订单管理
- 系统配置

## 📋 环境要求

- PHP 7.0+（推荐 PHP 8.1）
- MySQL 5.7+
- PDO扩展
- curl扩展
- mbstring扩展
- fileinfo扩展

## 🚀 安装部署

### 1. 上传文件
将所有文件上传到服务器

### 2. 导入数据库
```bash
mysql -u root -p < database/朋友圈访客.sql
```

### 3. 配置文件
编辑 `config/config.php`：
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
define('DB_NAME', 'your_database');
define('DEBUG_MODE', false); // 生产环境设为false
```

### 4. 设置目录权限
```bash
chmod 755 /path/to/project
chmod 777 /path/to/project/uploads
chmod 777 /path/to/project/logs
```

### 5. 配置微信公众号
1. 登录后台：`http://yourdomain.com/admin/login.php`
2. 默认账号：`zibibi` / 密码：`zibibi`
3. 进入"系统配置"填写微信AppID和Secret

## 📖 使用文档

### 后台登录
```
地址：/admin/login.php
默认账号：zibibi
默认密码：zibibi
```

### 微信配置
在系统配置中填写：
- 微信AppID
- 微信Secret
- 站点URL
- 公众号无限回调登录接口（可选）

### VIP功能
支持两种方式：
1. 在线支付（需配置易支付）
2. 卡密激活

## 🔐 安全建议

1. 修改默认管理员密码
2. 生产环境关闭DEBUG_MODE
3. 定期备份数据库
4. 使用HTTPS
5. 设置强密码

## 📞 联系方式

- **官方网站**：[https://ggdao.net](https://ggdao.net)
- **微信号**：IJG55555
- **更多源码**：[https://ggdao.net](https://ggdao.net)

## 📄 版权说明

本软件由锅岛主开发，版权所有 © 2026 锅岛主

更多优质源码请访问：[https://ggdao.net](https://ggdao.net)

---

**技术支持微信：IJG55555**
