﻿using System.Collections.Generic;
using UnityEngine;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using ProtoBuf;
using Oxide.Core;
using Oxide.Game.Rust.Cui;
using Network;


namespace Oxide.Plugins
{
    [Info("标点传送", "Damo", "1.0.0")]
    class MapTp : RustPlugin
    {

        private Dictionary<ulong, int> LengQueTime = new Dictionary<ulong, int>();

        private ConfigData configData;

        private Dictionary<ulong, string> HasQuan = new Dictionary<ulong, string>();

        private List<string> AllTequan = new List<string>();

        private class ConfigData
        {
            [JsonProperty(PropertyName = "聊天命令")]
            public string ChatCommand;

            [JsonProperty("消息提示编辑")]
            public Dictionary<string, string> MessagePrompt;

            [JsonProperty("= = = 特 权 设 置 = = =")]
            public Dictionary<string, MasterData> tequan;

        }
        private class MasterData
        {
            [JsonProperty("冷却时间秒")]
            public int lengquetime;
        }

        protected override void LoadConfig()
        {
            base.LoadConfig();
            configData = Config.ReadObject<ConfigData>();
            Config.WriteObject(configData, true);
        }

        protected override void LoadDefaultConfig() => configData = GetBaseConfig();

        protected override void SaveConfig() => Config.WriteObject(configData, true);
        private ConfigData GetBaseConfig()
        {
            return new ConfigData
            {
                ChatCommand = "bttp",
                MessagePrompt = new Dictionary<string, string>
                {
                    {"冷却提示","[ 标点传送 ] : 冷却剩余 <color=#66FF00>{0}</color> 秒 !" },
                    {"开启标点传送","[ 标点传送 ] : 开启" },
                    {"关闭标点传送","[ 标点传送 ] : 禁用" },
                    {"工具柜阻挡","[ 标点传送 ] : 您传送的位置有其他玩家的领地范围不允许传送" },

                },
                tequan = new Dictionary<string, MasterData>
                {
                    {"maptp.vip1",new MasterData { lengquetime = 300 } },
                    {"maptp.vip2",new MasterData { lengquetime = 180 } },
                    {"maptp.vip3",new MasterData { lengquetime = 10 } },
                }
            };
        }



        private void OnServerInitialized()
        {
            foreach (var item in configData.tequan.Keys)
            {
                permission.RegisterPermission(item, this);
                AllTequan.Add(item);
            }

            cmd.AddChatCommand(configData.ChatCommand, this, nameof(CustomChatCommand));
        }

        private Dictionary<ulong, string> TransferringPlayers = new Dictionary<ulong, string>();
        private void CustomChatCommand(BasePlayer player, string command, string[] args)
        {
            string quanx = VipQuanXian(player);
            if (quanx == null)
            {
                TransferringPlayers?.Remove(player.userID);
                return;
            }
            if (TransferringPlayers.ContainsKey(player.userID))
            {
                TransferringPlayers.Remove(player.userID);
                player.ChatMessage(configData.MessagePrompt["关闭标点传送"]);
            }
            else
            {
                player.ChatMessage(configData.MessagePrompt["开启标点传送"]);
                TransferringPlayers.Add(player.userID, quanx);
            }
        }

        private void Unload()
        {
            foreach (var player in BasePlayer.activePlayerList)
            {
                player.GetComponent<UIHandler>()?.Destroy();
                DestroyUi(player, "_maptp");
            }

        }
        private void DestroyUi(BasePlayer player, string name)
        {
            if (!string.IsNullOrEmpty(name)) CuiHelper.DestroyUi(player, name);
        }
        private void OnMapMarkerAdded(BasePlayer player, MapNote note)
        {
            if (player == null || note == null) return;

            if (!TransferringPlayers.TryGetValue(player.userID, out string quanx))
            {
                return;
            }
            if (LengQueTime.ContainsKey(player.userID))
            {
                var lengque = LengQueTime[player.userID] - Facepunch.Math.Epoch.Current;
                if (lengque > 0)
                {
                    UpDDXX(player, string.Format(configData.MessagePrompt["冷却提示"], lengque));
                    return;
                }
                else
                {
                    LengQueTime.Remove(player.userID);
                }

            }

            MasterData tequanx;
            if (configData.tequan.TryGetValue(quanx, out tequanx))
            {
                var pos = note.worldPosition;
                pos.y = GetGroundPosition(pos);
                if (!player.CanBuild(pos, default, default))
                {
                    UpDDXX(player, configData.MessagePrompt["工具柜阻挡"]);
                    return;
                }
                if (tequanx.lengquetime > 0)
                {
                    LengQueTime.Add(player.userID, Facepunch.Math.Epoch.Current + tequanx.lengquetime);
                }

                Teleport(player, pos);
            }


        }


        private static float GetGroundPosition(Vector3 pos)
        {
            float y = TerrainMeta.HeightMap.GetHeight(pos);
            RaycastHit hitInfo;

            if (Physics.Raycast(
                new Vector3(pos.x, pos.y + 200f, pos.z),
                Vector3.down,
                out hitInfo,
                float.MaxValue,
                (Rust.Layers.Mask.Vehicle_Large | Rust.Layers.Solid | Rust.Layers.Mask.Water)))
            {
                var cargoShip = hitInfo.GetEntity() as CargoShip;
                if (cargoShip != null)
                    return hitInfo.point.y;
                return Mathf.Max(hitInfo.point.y, y);
            }

            return y;
        }

        private void Teleport(BasePlayer player, Vector3 newPosition)
        {
            if (!player.IsValid() || Vector3.Distance(newPosition, Vector3.zero) < 5f) return;

            newPosition.y += 0.1f;
            var oldPosition = player.transform.position;
            player.PauseFlyHackDetection(5f);
            player.PauseSpeedHackDetection(5f);
            player.UpdateActiveItem(default(ItemId));
            player.EnsureDismounted();
            player.Server_CancelGesture();
            if (player.HasParent()) player.SetParent(null, true, true);
            if (player.IsConnected)
            {
                StartSleeping(player);
                player.SetPlayerFlag(BasePlayer.PlayerFlags.ReceivingSnapshot, true);
                //StartLoading_Quick
                player.ClientRPC(RpcTarget.SendInfo("StartLoading", new SendInfo(player.net.connection)), arg1: true);
            }
            player.Teleport(newPosition);
            if (player.IsConnected)
            {
                if (!player._limitedNetworking)
                {
                    player.UpdateNetworkGroup();
                    player.SendNetworkUpdateImmediate();
                }
                player.ClearEntityQueue(null);
                player.SendFullSnapshot();
                if (CanWake(player)) NextTick(player.EndSleeping);
            }

            if (!player._limitedNetworking)
            {
                player.ForceUpdateTriggers();
            }
            Interface.CallHook("OnPlayerTeleported", player, oldPosition, newPosition);
        }
        private bool CanWake(BasePlayer player)
        {
            return player.IsOnGround() || player.limitNetworking || player.IsFlying || player.IsAdmin;
        }
        public void StartSleeping(BasePlayer player)
        {
            if (!player.IsSleeping())
            {
                Interface.CallHook("OnPlayerSleep", player);
                player.SetPlayerFlag(BasePlayer.PlayerFlags.Sleeping, b: true);
                player.sleepStartTime = Time.time;
                BasePlayer.sleepingPlayerList.Add(player);
                player.CancelInvoke("InventoryUpdate");
                player.CancelInvoke("TeamUpdate");
                player.inventory.loot.Clear();
                player.inventory.containerMain.OnChanged();
                player.inventory.containerBelt.OnChanged();
                player.inventory.containerWear.OnChanged();
                player.Invoke("TurnOffAllLights", 0f);
                if (!player._limitedNetworking)
                {
                    player.EnablePlayerCollider();
                    player.RemovePlayerRigidbody();
                }
                else player.RemoveFromTriggers();
                player.SetServerFall(wantsOn: true);
            }
        }
        private string VipQuanXian(BasePlayer player)
        {
            for (int i = AllTequan.Count - 1; i >= 0; i--)
                if (permission.UserHasPermission(player.UserIDString, AllTequan[i]))
                {
                    return AllTequan[i];
                }
            return null;
        }
        private CuiElement YxText(string parent, string text, string anchorMin, string anchorMax, int DX = 11, TextAnchor align = TextAnchor.UpperLeft)
        { return new CuiElement { Parent = parent, Components = { new CuiTextComponent { Text = text, FontSize = DX, Color = "1 1 1 1", Align = align }, new CuiRectTransformComponent { AnchorMin = anchorMin, AnchorMax = anchorMax }, new CuiOutlineComponent { Color = "0 0 0 1", Distance = "-.5 .5" } } }; }
        private CuiPanel CJByx(string anchorMin, string anchorMax, string color = "0 0 0 0", bool SB = false)
        { return new CuiPanel { Image = { Color = color }, RectTransform = { AnchorMin = anchorMin, AnchorMax = anchorMax }, CursorEnabled = SB }; }
        private void UpDDXX(BasePlayer player, string Stext, string ZD = "Overlay")
        {
            var gwInfo = GetGwInfo(player);
            gwInfo.isDDXX = false;
            gwInfo.DDDXX();
            var elements = new CuiElementContainer();
            elements.Add(CJByx("0 .2", "1 .25"), ZD, "_maptp");
            elements.Add(YxText("_maptp", Stext, "0 0", "1 1", 30, TextAnchor.MiddleCenter));
            CuiHelper.AddUi(player, elements);
        }
        private class UIHandler : MonoBehaviour
        {
            public BasePlayer player;
            public bool isDDXX = false;

            public List<string> SPtxt = new List<string>();
            private void Awake()
            {
                player = GetComponent<BasePlayer>();
            }

            public void DDDXX()
            {
                if (!isDDXX)
                {
                    CancelInvoke("DDDXX");
                    CuiHelper.DestroyUi(player, "_maptp");
                    Invoke("DDDXX", 5f);
                    isDDXX = true;
                    return;
                }
                CuiHelper.DestroyUi(player, "_maptp");
            }
            public void Destroy() => Destroy(this);
        }
        private Dictionary<ulong, UIHandler> _playersUIHandler = new Dictionary<ulong, UIHandler>();
        private UIHandler GetGwInfo(BasePlayer player)
        {
            UIHandler value;
            if (!_playersUIHandler.TryGetValue(player.userID, out value))
            {
                _playersUIHandler[player.userID] = player.gameObject.AddComponent<UIHandler>();
                return _playersUIHandler[player.userID];
            }
            return value;
        }

    }
}
